; Set PDFSHX system variable to 0
; This controls whether SHX fonts are converted to text or geometry in PDF exports
; 0 = Convert SHX fonts to text (recommended for smaller file sizes)
(setvar "PDFSHX" 0)
(princ "\nPDFSHX set to 0 - SHX fonts will be converted to text in PDF exports")

; Set ANNOALLVISIBLE system variable to 1
; This makes all annotative scales visible in the current viewport
; 1 = All annotative object scales are displayed
(setvar "ANNOALLVISIBLE" 1)
(princ "\nANNOALLVISIBLE set to 1 - All annotative scales will be visible")

; Load TLENGTH____US_v101.lsp routine
; Get the current user's profile path dynamically
(setq lisp-path (strcat user-profile "C:\\CoSD Support Files\\2025\\2025.0.3\\Lsp\\TLENGTH____US_v101.lsp"))

(if (findfile lisp-path)
  (progn
    (load lisp-path)
    (princ "\nTLENGTH____US_v101.lsp loaded successfully")
  )
  (progn
    (princ "\nError: Could not find TLENGTH____US_v101.lsp at specified location")
    (princ "\nPath: ")
    (princ lisp-path)
  )
)

; Load LoadLocalSave routine
; Get the current user's profile path dynamically
(setq lisp-path (strcat user-profile "C:\\CoSD Support Files\\2025\\2025.0.3\\Lsp\\LoadLocalSave.lsp"))

(if (findfile lisp-path)
  (progn
    (load lisp-path)
    (princ "\nLoadLocalSave.lsp loaded successfully")
  )
  (progn
    (princ "\nError: Could not find LoadLocalSave.lsp at specified location")
    (princ "\nPath: ")
    (princ lisp-path)
  )
)

; Load TW.lsp routine
; Get the current user's profile path dynamically
(setq lisp-path (strcat user-profile "C:\\CoSD Support Files\\2025\\2025.0.3\\Lsp\\TW.lsp"))

(if (findfile lisp-path)
  (progn
    (load lisp-path)
    (princ "\nTW.lsp loaded successfully")
  )
  (progn
    (princ "\nError: Could not find TW.lsp at specified location")
    (princ "\nPath: ")
    (princ lisp-path)
  )
)
(princ "\nSetup complete.")
(princ)